 ; Ŀ
 ;   Fbt: find text entities which are not at an acceptable angle.         
 ;   Copyright 2001 by Rocket Software                                     
 ;   Dedicated to the Club of Rome - we're not dead yet.                   
 ; 

 ; Ŀ
 ;   Mark - draw a marker X at a point.                                    
 ; 
 (DEFUN MARK (pa rad colo)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Fbt.                                                                  
 ; 
 (DEFUN C:FBT (/ num nuf ss rad len so entt ang1 colo)
  (setq nuf 0)
 ; Ŀ
 ;   Get a selection set of Text, Attdefs, and blocks with attributes.     
 ; 
  (if (setq ss (ssget "X" '((-4 . "<or") (0 . "text")
                            (0 . "insert") (0 . "attdef") (-4 . "or>"))))
      (progn
           (setq rad (/ (getvar "viewsize") 25))
           (setq len (strcat "/" (itoa (sslength ss))))
           (setq num 0)
           (while (setq so (ssname ss num))
                  (setq entt (entget so))
                  (grtext -2 (strcat (itoa (setq num (1+ num))) len))
                  (setq ang1 (cdr (assoc 50 entt)))
 ; Ŀ
 ;   If text is upside down mark it.                                       
 ; 
                  (if (and (> ang1 (/ pi 2)) (<= ang1 (* pi 1.5)))
                      (progn
                           (setq typp (cdr (assoc 0 entt)))
                           (cond ((= typp "TEXT")
                                  (setq colo 2))
                                 ((= typp "INSERT")
                                  (setq colo 4))
                                 ((= typp "ATTDEF")
                                  (setq colo 7)))
                           (mark (cdr (assoc 10 entt)) rad colo)
                           (setq nuf (1+ nuf)))))
           (write-line (strcat "Twisted entities: " (itoa nuf))))
      (write-line "No text found."))
 (princ))